#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct {
    double x, y;
    int id;
} Point;

double manhattan(const Point *a, const Point *b) {
    return fabs(a->x - b->x) + fabs(a->y - b->y);
}

int main() {
    int n;
    double eps;
    if (scanf("%d %lf", &n, &eps) != 2) return 0;

    Point *all = malloc(n * sizeof(Point));
    for (int i = 0; i < n; i++) {
        scanf("%lf %lf", &all[i].x, &all[i].y);
        all[i].id = i + 1;
    }

    int max_cells = (int)(1.0 / eps) + 2;
    int grid_size = max_cells * max_cells;

    int *used = calloc(grid_size, sizeof(int));
    Point *Q = malloc(grid_size * sizeof(Point));
    int qn = 0;

    for (int i = 0; i < n; i++) {
        int cx = (int)(all[i].x / eps);
        int cy = (int)(all[i].y / eps);
        if (cx < 0) cx = 0;
        if (cy < 0) cy = 0;
        if (cx >= max_cells) cx = max_cells - 1;
        if (cy >= max_cells) cy = max_cells - 1;

        int idx = cx * max_cells + cy;
        if (!used[idx]) {
            used[idx] = 1;
            Q[qn++] = all[i];
        }
    }

    if (qn == 0) {
        printf("0\n\n");
        return 0;
    }

    double *dist = malloc(qn * sizeof(double));
    int *parent = malloc(qn * sizeof(int));
    int *in_mst = calloc(qn, sizeof(int));

    for (int i = 0; i < qn; i++) {
        dist[i] = 1e100;
        parent[i] = -1;
    }

    dist[0] = 0.0;

    for (int it = 0; it < qn; it++) {
        int v = -1;
        for (int i = 0; i < qn; i++) {
            if (!in_mst[i] && (v == -1 || dist[i] < dist[v])) {
                v = i;
            }
        }

        in_mst[v] = 1;

        for (int u = 0; u < qn; u++) {
            if (!in_mst[u]) {
                double w = manhattan(&Q[v], &Q[u]);
                if (w < dist[u]) {
                    dist[u] = w;
                    parent[u] = v;
                }
            }
        }
    }

    printf("%d\n", qn);
    for (int i = 0; i < qn; i++) {
        printf("%d%s", Q[i].id, i + 1 == qn ? "\n" : " ");
    }

    for (int i = 1; i < qn; i++) {
        printf("%d %d\n", Q[i].id, Q[parent[i]].id);
    }

    free(all);
    free(used);
    free(Q);
    free(dist);
    free(parent);
    free(in_mst);
    return 0;
}